log_get_timer () {
  date '+%s'
}

v_log_timer="$(log_get_timer)"
v_log_section="None"

log () {
  logger -t "aw-fbsd-monitoring" "$@"
}

to_status () {
  cat | awk -v n="$1" '{print n, " : ", $0}' >> "$STATE_ROOT/status"
}

log_err () {
  log -p user.err -s "$@" 2<&1 | to_status
}



write_status () {
  local module="$1"
  shift
  echo "$0" | to_status "$module"
}

log_start () {
  log "$1: start"
  v_log_timer="$(log_get_timer)"
  v_log_section="$1"
}

log_end () {
  local t
  t="$(( $(log_get_timer) - $v_log_timer ))"
  log "${v_log_section}: end in $t seconds"
}