#!/bin/bash
src_root="$(dirname "$(dirname "$(readlink -f "$0")")")"
dist_root="$(readlink -f "$src_root/../dist")"

### VARS
dist_name="aw.fbsd-mon-helper.tgz"
dist_s3_link="s3fs/dist/config/zabbix/freebsd-template/${dist_name}"

echo "###"
tar -cvzf "${dist_root}/${dist_name}" \
   --owner=root --group=root \
   -C "$src_root/src" \
   aw.fbsd-mon-helper

echo "==="
echo "${dist_root}/${dist_name}"
stat "${dist_root}/${dist_name}"

if [ "$(which mioctl)" ] && [ -f "${dist_root}/${dist_name}" ] ; then
  echo "### PUSH DISTRIBUTION TO FS ###"
  read -p "Upload file [y/N]: " _ans
  case "$_ans" in 
    [Yy] | [yY][eE][sS] )
      mioctl cp "${dist_root}/${dist_name}" "$dist_s3_link"
      ;;
   
    * )
      echo "WARNING: Answer is '${_ans}', abort uploading"
      ;;
  
  esac
fi

