#!/bin/bash
# devel.a0fs.ru -- ncc.zabbix_templates/pgbouncer/install.sh -- v0.r202310.1 #

export PATH="/sbin:/bin:/usr/sbin:/usr/bin:/usr/local/sbin:/usr/local/bin"
appdir="$(dirname "$(readlink -f "$0")")"

install -d -o zabbix -g zabbix -m u=rwx,g=rx,o-rwx \
    /etc/zabbix/scripts/ \
    /etc/zabbix/scripts-data \
    /etc/zabbix/scripts-data/pgbouncer

echo "PGBOUNCER PORT"
read -p "Port: " pgb_port

echo "MONITRONG USER CREDENTIALS"
read -p "User: " uid_name
read -p "Passwd: " -r -s uid_passwd

cat > /etc/zabbix/scripts-data/pgbouncer/.pgpass << EOF
127.0.0.1:${pgb_port:-6432}:*:${uid_name:-zbx_mon}:${uid_passwd}
EOF

chown zabbix:zabbix /etc/zabbix/scripts-data/pgbouncer/.pgpass
chmod go-rwx /etc/zabbix/scripts-data/pgbouncer/.pgpass

install -o zabbix -g zabbix ${appdir}/res/pgbouncer.sh ${PREFIX}etc/zabbix/scripts/

for fle  in /etc/zabbix/zabbix_agentd.d/ /etc/zabbix/zabbix_agentd2.d/ \
            /etc/zabbix/zabbix_agent.d/ /etc/zabbix/zabbix_agent2.d/ ; do
	
    if ! [ -d "$fle" ] ; then 
		continue 
	
	fi;
	
    install -o zabbix -g zabbix -m u=rw,go=r ${appdir}/res/pgbouncer.conf  ${fle}

done
