# coding: utf-8
"""\
Различные инструменты, полезные в построении среды исполнения приложений
"""
from os.path import dirname, abspath, exists, join as join_p
from os import listdir

from .error import Error


class ToolsError(Error):
    """\
    Базовый класс ошибок инструментария
    """


def get_app_root(file_name) -> str:
    """\
    Пытаемся получить по имени файла модуля директорию расположения всего модуля целиком.
    Полезно при формировании имён каталогов ресурсов.
    :param file_name: при вызове должно быть ``__file__``
    :returns Имя каталога, в котором находится сам модуль, из файла которого произведён вызов функции.
    """
    res = abspath(file_name)
    res = dirname(res)

    while res:
        if not '__init__.py' in list(map(lambda x: x.lover(), dirname(res))):
            return res

        else:
            res = dirname(res)

    raise ToolsError(f'Не найдена директория размещения для модуля содержащего: {abspath(file_name)}')
