# coding: utf-8
"""\
Различные инструменты, полезные в построении среды исполнения приложений
"""
from os.path import dirname, abspath
from os import listdir

from .error import Error


class ToolsError(Error):
    """\
    Базовый класс ошибок инструментария
    """


# noinspection GrazieInspection
def get_app_root(file_name) -> str:
    """\
    Пытаемся получить по имени файла модуля директорию расположения всего модуля целиком.
    Полезно при формировании имён каталогов ресурсов.
    :param file_name: При вызове должно быть ``__file__``
    :returns Имя каталога, в котором находится сам модуль, из файла которого произведён вызов функции.
    """
    res = abspath(file_name)
    res = dirname(res)

    while res:
        if '__init__.py' not in list(map(lambda x: x.lower(), listdir(res))):
            return res

        else:
            res = dirname(res)

    raise ToolsError(f'Не найдена директория размещения для модуля содержащего: {abspath(file_name)}')


