# db_migrator

## Окружение

Для обеспечения миграции должен быть развёрнут каталог с данными миграции и в БД присутствовать отношение, хранящее версию текущей схемы.

Для организации миграции необходимо создать и поддерживать директорию определённой структуры:

```yaml
- schema.sql: Файл с начальной схемой данных
  patch: # Каталог с изменениями
  - 0.sql
  - 1.sql
  # ...
```

Схема таблицы с версией:

```sql
CREATE TABLE app_version_info (
   version integer default -1
);
```

Имя таблицы значения не имеет, так как задаётся при вызове класса миграции. Однако **схема должна** соответствовать.

В методах принимающих `<tt class="remarkup-monospaced">db</tt>`, ему нужно передавать объект <tt class="remarkup-monospaced">connection</tt> `<tt class="remarkup-monospaced">DB API 2</tt>` стандартный для <tt class="remarkup-monospaced">Python</tt>.

БД, за версией которой мы следим, естественно должна взаимодействовать посредством простого <tt class="remarkup-monospaced">SQL</tt>. Модуль не выполняет каких-то сложных манипуляций, а простым `<tt class="remarkup-monospaced">SELECT</tt>` запрашивает данные, и исполняет `<tt class="remarkup-monospaced">UPDATE</tt>` при обновлении данных о версии

#### Структура файла схемы и файлов изменений

Файл схемы должен состоять из отдельных команд на изменение схемы разделённых маркетом `<tt class="remarkup-monospaced">--</tt>`, который должен идти первым не пробельным символом. По данному маркеру происходит разбиение файла на отдельные команды. После этих символов содержание остальной строки игнорируется, а сама строка в команду не входит.

Каждая команда исполняется отдельно и после её выполнения происходит <tt class="remarkup-monospaced">commit</tt>. Поэтому необходимо **внимательно** следить за согласованностью данных после применения команды.

**Имена файлов изменений** должны оканчиваться на <tt class="remarkup-monospaced">.sql</tt> (регистр не важен) и первые символы до точки должны приводится к числу. Данное число будет версией, к торовой данный файл приводит схему.

То есть имя файла рекомендуется составлять из 3-х компонентов, разделённых точками:

```
00001.some_comment.sql
```

**где:**

- `<tt class="remarkup-monospaced">00001</tt>` - версия, количество нулей роли не играет
- `<tt class="remarkup-monospaced">some_comment</tt>` - пояснение к изменению, не является обязательным
- `<tt class="remarkup-monospaced">sql</tt>` - расширение файла, относящее его к <tt class="remarkup-monospaced">SQL</tt>.

### Документация

#### Классы

<div class="remarkup-table-wrap" id="bkmrk-"></div><div class="remarkup-table-wrap" id="bkmrk-%D0%98%D0%BC%D1%8F-%D0%BA%D0%BB%D0%B0%D1%81%D1%81%D0%B0-%D0%9E%D0%BF%D0%B8%D1%81%D0%B0%D0%BD%D0%B8%D0%B5-"><div class="remarkup-table-wrap"><table border="1" style="border-collapse: collapse; width: 100%;"><colgroup><col style="width: 21.3818%;"></col><col style="width: 78.5935%;"></col></colgroup><tbody><tr><th class="align-center" style="background-color: rgb(236, 240, 241); vertical-align: bottom;">**Имя класса**</th><th class="align-center" style="background-color: rgb(236, 240, 241); vertical-align: bottom;">**Описание**</th></tr><tr><td>`<tt class="remarkup-monospaced">MigrateManager</tt>`</td><td>Менеджер миграции. Выполняет всю работу</td></tr><tr><td>`<tt class="remarkup-monospaced">MigrateError</tt>`</td><td>Класс собственных исключений модуля</td></tr></tbody></table>

</div></div>#### Методы класса `<tt class="remarkup-monospaced">MigrateManager</tt>`

##### Конструктор

**Параметры:**

<table border="1" id="bkmrk-control_table-str-o-" style="border-collapse: collapse; width: 100%;"><colgroup><col style="width: 14.953%;"></col><col style="width: 10.8749%;"></col><col style="width: 4.36944%;"></col><col style="width: 69.6543%;"></col></colgroup><tbody><tr><td>`<tt class="remarkup-monospaced">control_table</tt>`</td><td>`<tt class="remarkup-monospaced">str</tt>`</td><td>`<tt class="remarkup-monospaced">O</tt>`</td><td>Имя таблицы, хранящей версию (схема её дана выше)</td></tr><tr><td>`<tt class="remarkup-monospaced">migrate_env</tt>`</td><td>`<tt class="remarkup-monospaced">str(path)</tt>`</td><td>`<tt class="remarkup-monospaced">O</tt>`</td><td>Каталог с файлами миграции. Структура описана выше</td></tr></tbody></table>

**Выполняет:** общие проверки среды, команд на БД не вызывает

##### `<tt class="remarkup-monospaced">init_db</tt>`

**Параметры:**

<table border="1" id="bkmrk-db-%D0%9E%D0%B1%D1%8A%D0%B5%D0%BA%D1%82-%D0%91%D0%94-o-%D0%9E%D0%B1%D1%8A%D0%B5%D0%BA" style="border-collapse: collapse; width: 100%;"><colgroup><col style="width: 7.78547%;"></col><col style="width: 11.6164%;"></col><col style="width: 4.44811%;"></col><col style="width: 76.1253%;"></col></colgroup><tbody><tr><td>`<tt class="remarkup-monospaced">db</tt>`</td><td>`<tt class="remarkup-monospaced">Объект БД</tt>`</td><td>`<tt class="remarkup-monospaced">O</tt>`</td><td>Объект БД, должен соответствовать описанному выше интерфейсу</td></tr></tbody></table>

**Выполняет:** Исполнение на БД команд из файла начальной схемы

##### `<tt class="remarkup-monospaced">check</tt>`

**Параметры:**

<table border="1" id="bkmrk-db-%D0%9E%D0%B1%D1%8A%D0%B5%D0%BA%D1%82-%D0%91%D0%94-o-%D0%9E%D0%B1%D1%8A%D0%B5%D0%BA-1" style="border-collapse: collapse; width: 100%;"><colgroup><col style="width: 4.81957%;"></col><col style="width: 12.4815%;"></col><col style="width: 4.50132%;"></col><col style="width: 78.0493%;"></col></colgroup><tbody><tr><td>`<tt class="remarkup-monospaced"></tt>db`</td><td>`Объект БД`</td><td>`O`</td><td>Объект БД, должен соответствовать описанному выше интерфейсу</td></tr></tbody></table>

**Выполняет:** Проверку версию схемы БД, и исполнение на БД команд из файлов версий выше текущей на БД.

<p class="callout warning">При отсутствии таблицы модуль просто возбудит исключение, причём это исключение возбудит сама база, поскольку запрошенной таблицы в ней не окажется.</p>