# coding: utf-8
# devel.a0fs.ru -- aw_log.syslog -- v0.r202402.1

import syslog
from typing import Any

from . import AbstractLogBase

PRIORITY_BY_MARK = {
    "`": syslog.LOG_DEBUG,    # Debug
    ".": syslog.LOG_INFO,     # Info
    "*": syslog.LOG_WARNING,  # Warning
    "!": syslog.LOG_ERR,      # Error
    "#": syslog.LOG_ALERT,    # Alert
}


class SysLog(AbstractLogBase):
    @staticmethod
    def init_syslog(ident):
        syslog.openlog(ident, syslog.LOG_PID)

    def __init__(self, prefix: str = 'main', facility=syslog.LOG_USER):
        super().__init__(prefix=prefix)
        self.facility = facility

    def _write(self, mark: str, msg: Any):
        flag = self.facility | PRIORITY_BY_MARK.get(mark, syslog.LOG_INFO)

        for l in self._write_helper(mark=mark, msg=msg):
            syslog.syslog(flag, l)
