# coding: utf-8

from typing import Any
from time import ctime
from sys import stderr, stdout
from typing import TextIO, Optional

from . import AbstractLogBase


class AbstractConsoleLog(AbstractLogBase):
    def __init__(self, prefix: str = 'main'):
        super().__init__(prefix)
        self.fd: Optional[TextIO] = None

    def _write(self, mark: str, msg: Any):
        if self.fd is None:
            raise ValueError(f'Не определён канал логирования')

        tm = ctime()
        for l in super()._write_helper(mark, msg):
            self.fd.write(f'{tm} | {l}')


class StdoutLog(AbstractConsoleLog):
    def __init__(self, prefix: str = 'main'):
        super().__init__(prefix)
        self.fd = stdout


class StderrLog(AbstractConsoleLog):
    def __init__(self, prefix: str = 'main'):
        super().__init__(prefix)
        self.fd = stderr
