# coding: utf-8 -*-
#  Инструменты для работы с URL
from base64 import urlsafe_b64encode as _b64e, urlsafe_b64decode as _b64d
from urllib.parse import quote, unquote


def b64_encode(buf: str) -> str:
    return _b64e(buf.encode('UTF-8')).decode('UTF-8')


def b64_decode(buf: str) -> str:
    return _b64d(buf.encode('UTF-8')).decode('UTF-8')


def url_quote(buf: str) -> str:
    return quote(buf)


def url_unquote(buf: str) -> str:
    return unquote(buf)
