#!/usr/bin/python
# -*- coding: utf-8 -*-

from signal import SIGALRM, alarm, signal

class AlarmTimeout(Exception): pass

def _handler(sig, frame):
	raise AlarmTimeout('Operation timeout')

class MkAlarm(object):
	def __init__(self, timeout):
		signal(SIGALRM, _handler)
		alarm(timeout)
		
	def __enter__(self):
		pass
		
	def __exit__(self, eType, eObj, tb):
		if eObj == None:
			alarm(0)
	
	def __del__(self):
		alarm(0)
			