# -*- coding: utf-8 -*-
# ---
#  Модуль среды приложений для Windows
# ---

from bottle import Bottle as App, request as Req, response as Ans, SimpleTemplate as BottleTemplate, abort as Abort
from os.path import dirname, abspath as pAbs, split as pSplit, join as pJoin

# --- CLASSES ---
class ReqEnv:
	def __init__(self):
		self.urlBase = Req.environ.get('SCRIPT_NAME', '')
		
	def getUrl(self, url):
		url = str(url)
		buf = self.urlBase
		buf += url if url.startswith('/') else '/' + url
		return buf
	
	def __getitem__(self, key):
		return Req.environ[key]
		
	def __iter__(self):
		for key in Req.environ.keys():
			yield key
			
	@staticmethod
	def abort(*a, **ka):
		Abort(*a, **ka)
	
	@staticmethod	
	def get(self):
		return Req.GET
		
	@staticmethod	
	def post():
		return Req.POST
		
class Env:
	def __init__(self, scFile):
		self.wd = pSplit(dirname(pAbs(scFile)))[0]
		self.static = pJoin(self.wd, 'static')
		
	def http(self, tplName):
		return BottleTemplate(name=pJoin(self.wd, 'http', '%s.html' % tplName)).render
		
	def db(self):
		""" 
		Путь к базе SQLite, иные типы БД дожны иметь более
		серьёзные средства авторизации
		"""
		return pJoin(self.wd, 'db.sqlite')
	
	@staticmethod
	def httpTpl(buf):
		return BottleTemplate(buf).render
	
	@staticmethod
	def app():
		return App()
		
	@staticmethod
	def appRun(app):
		app.run(server='cgi')
	
# --- PROCS ---
def runApp(app):
	Env.appRun(app)
	
def Template(buf):
	return Env.httpTpl(buf)
	