# coding: utf-8
import ldap

# ===========================================================
# Статус завершения оперций
STATUS_OK = 0           # Всё ОК.
STATUS_BADAUTH = 1      # Не верные пользователь или пароль.
STATUS_SERVERDOWN = 2   # Сервер не доступен.
STATUS_SERVERERROR = 3  # Ошибка при взаимодействии с сервером.

class LdapError(Exception): pass

class LdapAuth(object):
	def __init__(self, server, userPrefix = 'CORP\\', baseDN = 'DC=example,DC=net', attr = []):
		self.server = server
		self.prefix = userPrefix
		self.status = ''
		self.baseDN = baseDN
		self.statusCode = 0
		self.groups = None
		self.attr = None
		self._needAttr = [ i for i in map(str, attr) ]
		
	def __call__(self, user, passwd):
		try:
			conn = ldap.initialize(self.server)
			conn.set_option(ldap.OPT_REFERRALS, 0)
			conn.simple_bind_s(self.prefix + user, passwd)
		except ldap.INVALID_CREDENTIALS:
			conn.unbind()
			self.status = 'Invalid credentials'
			self.statusCode = STATUS_BADAUTH
			return False
		except ldap.SERVER_DOWN:
			self.status = 'Server is down'
			self.statusCode = STATUS_SERVERDOWN
			return False
		
		self.groups = []
		try:
			ldapData = conn.search_s(self.baseDN, ldap.SCOPE_SUBTREE, '(cn=%s)' % user, ['memberOf'] + self._needAttr)[0][1]
			for i in ldapData['memberOf']:
				self.groups.append(i.split(',')[0].split('=')[1].decode('utf-8'))
			del ldapData['memberOf']
			self.attr = ldapData
		except KeyError:
			self.status = 'User object from LDAP is wrong, it can be anonymous logon'
			self.statusCode = STATUS_SERVERERROR
			return False
		finally:
			conn.unbind()			

		return True
	
	def __getitem__(self, key):
		return self.attr[key]
	
	def memberOf(self, group):
		"""Проверка на присутствие у пользователя некоторой группы
		"""
		if self.groups == None:
			raise LdapError('Request membership before auth call.')
			
		if not isinstance(group, unicode):
			if isinstance(group, str):
				group = group.decode('utf-8')
			else:
				group = str(group).decode('utf-8')
		
		if group in self.groups:
			return True
		else:
			return False
	
	def __contains__(self, group):
		return self.memberOf(group)
		
	def memberOfGroups(self, groups):
		if not len(groups) > 0:
			return False
		
		for group in groups:
			if not group in self:
				return False
		
		return True
