# coding: utf-8
import sqlite3
from sqlite3 import Error, IntegrityError


class DB:
    def __init__(self, db_file):
        self._conn = sqlite3.connect(db_file)
        self._ex = self._conn.execute
        self.commit = self._conn.commit
        self.rollback = self._conn.rollback

        # DB PREP
        self._ex("PRAGMA journal=WAL")
        self._ex("PRAGMA foreign_keys=ON")
        self.commit()

    def __del__(self):
        try:
            self.rollback()
            self._conn.close()
        except:
            pass

    def __call__(self, *a, **kwa):
        cur = self._conn.cursor()
        cur.execute(*a, **kwa)
        return cur

    def cq(self, *a, **wa):
        try:
            res = self(*a, **wa)
            self.commit()
            return res
        except Error as e:
            self.rollback()
            raise e
