# -*- coding: utf-8 -*-
import psycopg2
from psycopg2 import Error as DBError, Warning, DataError, IntegrityError, ProgrammingError
# DBError: Клас-родитель для всех ошибок
# DataError: Проблема с данными (деление на ноль, численное изначение за областью значение и пр.)
# IntegrityError: задеты ограничения целостности БД (уникольность, внешние ключи и пр.)
# ProgrammingError: ошибки в запросах (таблица не найдена, или уже существует, ошибка в синтаксисе запроса и пр.)

import psycopg2.extensions
psycopg2.extensions.register_type(psycopg2.extensions.UNICODE)
psycopg2.extensions.register_type(psycopg2.extensions.UNICODEARRAY)

class Error(Exception): pass


def dbFactory(**kva):
	""" Фабрика объектов	
	"""
	def _func():
		return DB(**kva)
	return _func

class DB(object):
	def __init__(self, **kva):
		self._conn = psycopg2.connect(**kva)
		self.commit = self._conn.commit
		self.rollback = self._conn.rollback
		self.cursor = self._conn.cursor
		self.reset = self._conn.reset
	
	def __enter__(self, *a, **kva):
		return self._conn.__enter__(*a, **kva)
		
	def __exit__(self, *a, **kva):
		return self._conn.__exit__(*a, **kva)
	
	def __call__(self, *a, **kva):
		_cur = self.cursor()
		_cur.execute(*a, **kva)
		return _cur
		
	def cq(self, *a, **kva):
		try:
			_cur = self.cursor()
			_cur.execute(*a, **kva)
			self.commit()
			return _cur
		except Exception as e:
			self.rollback()
			raise e
			
	def close(self):
		try:
			self.rollback()
			self._conn.close()
		except:
			pass		
	
	def __del__(self):
		self.close()
	
	def __repr__(self):
		return 'DB(%s)' % self._conn.dsn
		
	
		
		


