import postgresql.driver as DBM
import postgresql.exceptions as DBErr

def GetDB(*, name, user, passwd, host='localhost', port=5432):
  """
  На случай когда лениво каждый раз вызывать базу со всеми регалиями,
  регалии сохраняем в специального вызывателя :)))
  """
  def func ():
    return DB(name, user, passwd, host=host, port=port)
  return func

class DB:
  def __init__(self, db_name, db_user, db_passwd, *, host='localhost', port=5432):
    self._db = DBM.connect(
      host = host,
      port = port,
      user = db_user,
      password = db_passwd,
      database = db_name
    )
    self.xact = self._db.xact
    self.q = self._db.query
    self.pq = self._db.prepare
    self.ex = self._db.execute
    self.proc = self._db.proc
    self.close = self._db.close
  
  def __del__(self):
    if self._db.state != 'closed':
      self._db.close()