# coding: utf-8
# devel.a0fs.net: pgadmin.selfServerAsync - v0.1 by awgur $

##########################################################################
#
# pgAdmin 4 - PostgreSQL Tools
#
# Copyright (C) 2013 - 2018, The pgAdmin Development Team
# This software is released under the PostgreSQL Licence
#
##########################################################################

from gevent import monkey; monkey.patch_all()
from gevent.pywsgi import WSGIServer
import os
import sys
import logging
from logging.handlers import SysLogHandler


def prepLogger():
    _format = 'lo.ad.pgadmin[%(process)d]: %(message)s'
    _logHandler = SysLogHandler(address='/dev/log', facility='user')
    _logHandler.setFormatter(logging.Formatter(_format))    
    logging.basicConfig(level=logging.INFO)
    _log = logging.getLogger()
    _log.handlers = [_logHandler,]

root = os.path.dirname(os.path.realpath(__file__))
if sys.path[0] != root:
    sys.path.insert(0, root)

if sys.version_info[0] >= 3:
    import builtins
else:
    import __builtin__ as builtins

# Ensure the global server mode is set.
builtins.SERVER_MODE = True

import config
# Monkey Path Dumy pgAdmin CONFIG
config.DATA_DIR = os.getenv('DATA_DIR') or config.DATA_DIR
config.SQLITE_PATH = os.getenv('SQLITE_PATH') or os.path.join(config.DATA_DIR, 'pgadmin4.db')
config.SESSION_DB_PATH = os.path.join(config.DATA_DIR, 'sessions')
config.STORAGE_DIR = os.path.join(config.DATA_DIR, 'storage')
config.TEST_SQLITE_PATH = os.path.join(config.DATA_DIR, 'test_pgadmin4.db')


# When running it as a WSGI application, directory for the configuration file
# must present.
if not os.path.exists(os.path.dirname(config.SQLITE_PATH)):
    raise Exception(
        """
Required configuration file is not present!
Please run setup.py first!"""
    )

from pgAdmin4 import app as application
prepLogger()
log = logging.getLogger()

WSGIServer(('0.0.0.0', 44000), application, log=log, error_log=log).serve_forever()
