# coding: utf-8
from dataclasses import is_dataclass, asdict


def json_type_sanitizer(val):
    """\
    Преобразует значение ``val`` в пригодное для преобразования в json значение.
    """

    val_t = type(val)

    if is_dataclass(val):
        return json_type_sanitizer(asdict(val))

    elif val_t in (int, float, str, bool) or val is None:
        return val

    elif val_t in (list, tuple):
        return list(map(json_type_sanitizer, val))

    elif val_t == dict:
        return dict((key, json_type_sanitizer(d_val)) for key, d_val in val.items())

    else:
        return str(val)
