// devel.a0fs.ru -- aw_id -- v1.r202504.1 //
/*
  Утилиты генерирования полезных в работе ID
*/
package main

import (
	"fmt"
	"os"
	"time"

	"encoding/base64"
	"encoding/binary"
	"strconv"

	"github.com/google/uuid"
)

const (
	TIME_ID = iota
	TIME_HUM
	TIME_HUM_RU
	TIME_HUM_SAFE
	TIME_HUM_SAFE2
	TIME_ID_SHORT
	TIME_ID_SHORT2
)

func get_time_id(id_type int) string {
	cur_time := time.Now()
	var time_format string = time.RFC3339

	switch id_type {
	case TIME_ID:
		time_format = "20060102-150405"
	case TIME_HUM_RU:
		time_format = "02.01.2006 15:04:05"
	case TIME_HUM:
		time_format = "2006-01-02 15:04:05"
	case TIME_HUM_SAFE:
		time_format = "2006-01-02 15-04-05"
	case TIME_HUM_SAFE2:
		time_format = "2006-01-02_15-04-05"
	case TIME_ID_SHORT:
		time_format = "20060102"
	case TIME_ID_SHORT2:
		time_format = "200601"
	}

	return cur_time.Format(time_format)
}

func get_uuid() string {
	res := uuid.New()
	return res.String()
}

func get_ver_id() string {
	return fmt.Sprintf("v0.r%s.1", get_time_id(TIME_ID_SHORT2))
}

func get_ver_id2() string {
	return fmt.Sprintf("0.%s.1", get_time_id(TIME_ID_SHORT2))
}

func get_ver_auto_tag() string {
	var auto_version string = "AAAAAA"

	buf := make([]byte, 8)
	buf_time := time.Now()
	buf_u64, err := strconv.ParseUint(buf_time.Format("02150405"), 10, 64)
	if err == nil {
		buf_u64 = buf_u64*uint64(100) + uint64(buf_time.Nanosecond()/10000000)
		_, err = binary.Encode(buf, binary.BigEndian, buf_u64)
		if err == nil {
			auto_version = base64.RawURLEncoding.EncodeToString(buf[4:])

		}
	}

	return auto_version
}

func get_ver_id3() string {
	return fmt.Sprintf("v0.r%s.%s", get_time_id(TIME_ID_SHORT2), get_ver_auto_tag())
}

func get_ver_id4() string {
	return fmt.Sprintf("0.%s.%s", get_time_id(TIME_ID_SHORT2), get_ver_auto_tag())
}

func prnt_out(k, v string) {
	fmt.Printf("%10s : %s\n", k, v)
}

func make_all_ids() {
	prnt_out("uuid", get_uuid())
	prnt_out("ts", get_time_id(TIME_ID))
	prnt_out("tss", get_time_id(TIME_ID_SHORT))
	prnt_out("tss2", get_time_id(TIME_ID_SHORT2))
	prnt_out("hr", get_time_id(TIME_HUM))
	prnt_out("hrr", get_time_id(TIME_HUM_RU))
	prnt_out("hrs", get_time_id(TIME_HUM_SAFE))
	prnt_out("hrs2", get_time_id(TIME_HUM_SAFE2))
	prnt_out("v", get_ver_id())
	prnt_out("va", get_ver_id3())
	prnt_out("vs", get_ver_id2())
	prnt_out("vsa", get_ver_id4())
	fmt.Println("")
}

func main() {
	if len(os.Args) > 1 {
		switch os.Args[1] {
		case "uuid":
			fmt.Println(get_uuid())
		case "ts":
			fmt.Println(get_time_id(TIME_ID))
		case "hr":
			fmt.Println(get_time_id(TIME_HUM))
		case "hrr":
			fmt.Println(get_time_id(TIME_HUM_RU))
		case "hrs":
			fmt.Println(get_time_id(TIME_HUM_SAFE))
		case "hrs2":
			fmt.Println(get_time_id(TIME_HUM_SAFE2))
		case "tss":
			fmt.Println(get_time_id(TIME_ID_SHORT))
		case "tss2":
			fmt.Println(get_time_id(TIME_ID_SHORT2))
		case "v":
			fmt.Println(get_ver_id())
		case "va":
			fmt.Println(get_ver_id3())
		case "vs":
			fmt.Println(get_ver_id2())
		case "vsa":
			fmt.Println(get_ver_id4())
		default:
			fmt.Println("Need one of: ")
			fmt.Println("  uuid, ts, tss, tss2, hr, hrr, hrs, hrs2,")
			fmt.Println("  v, va, vs, vsa")
		}
		fmt.Println("")
	} else {
		make_all_ids()
	}
}
