// devel.a0fs.ru -- aw_id -- v1.r202505.1 //
/*
  Утилиты генерирования полезных в работе ID
*/
package main

import (
	"fmt"
	"os"
	"time"

	"strconv"

	"github.com/google/uuid"
	"github.com/oleg-vasiliev/uuid7"
)

const (
	TIME_ID = iota
	TIME_HUM
	TIME_HUM_RU
	TIME_HUM_SAFE
	TIME_HUM_SAFE2
	TIME_ID_SHORT
	TIME_ID_SHORT2
)

func get_time_id(id_type int) string {
	cur_time := time.Now()
	var time_format string = time.RFC3339

	switch id_type {
	case TIME_ID:
		time_format = "20060102-150405"
	case TIME_HUM_RU:
		time_format = "02.01.2006 15:04:05"
	case TIME_HUM:
		time_format = "2006-01-02 15:04:05"
	case TIME_HUM_SAFE:
		time_format = "2006-01-02 15-04-05"
	case TIME_HUM_SAFE2:
		time_format = "2006-01-02_15-04-05"
	case TIME_ID_SHORT:
		time_format = "20060102"
	case TIME_ID_SHORT2:
		time_format = "200601"
	}

	return cur_time.Format(time_format)
}

func get_uuid() string {
	res := uuid.New()
	return res.String()
}

func get_uuid7() string {
	res, err := uuid7.New()

	if err != nil {
		return "00000000-0000-0000-0000-000000000000"

	} else {
		return res.String()

	}
}

func get_ver_id() string {
	return fmt.Sprintf("v0.r%s.1", get_time_id(TIME_ID_SHORT2))
}

func get_ver_id2() string {
	return fmt.Sprintf("0.%s.1", get_time_id(TIME_ID_SHORT2))
}

func get_ver_auto_tag() string {
	const CDB uint64 = 62
	var auto_version []byte = []byte{
		'0', '0', '0',
		'0', '0', '0'}

	var CD [CDB]byte = [CDB]byte{'0', '1', '2', '3', '4', '5', '6',
		'7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I',
		'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U',
		'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g',
		'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's',
		't', 'u', 'v', 'w', 'x', 'y', 'z'}

	buf_time := time.Now()
	buf_u64, err := strconv.ParseUint(buf_time.Format("02150405"), 10, 64)
	if err == nil {
		buf_u64 = buf_u64*uint64(100) + uint64(buf_time.Nanosecond()/10000000)
		if err == nil {
			var buf_u64_idx uint64
			var ar_idx uint = 5

			for buf_u64 >= CDB && ar_idx > 0 {
				buf_u64_idx = buf_u64 % CDB
				buf_u64 /= CDB
				auto_version[ar_idx] = CD[buf_u64_idx]
				ar_idx--
			}

			if buf_u64 >= CDB {
				panic(fmt.Sprintf("get_ver_auto_tag: Need more size in buffer, value %v > %v", buf_u64, CDB))

			} else {
				auto_version[ar_idx] = CD[buf_u64]

			}

		}
	}

	return string(auto_version)
}

func get_ver_id3() string {
	return fmt.Sprintf("v0.r%s.%s", get_time_id(TIME_ID_SHORT2), get_ver_auto_tag())
}

func get_ver_id4() string {
	return fmt.Sprintf("0.%s.%s", get_time_id(TIME_ID_SHORT2), get_ver_auto_tag())
}

func prnt_out(k, v string) {
	fmt.Printf("%10s : %s\n", k, v)
}

func make_all_ids() {
	prnt_out("uuid", get_uuid())
	prnt_out("uuid7", get_uuid7())
	prnt_out("ts", get_time_id(TIME_ID))
	prnt_out("tss", get_time_id(TIME_ID_SHORT))
	prnt_out("tss2", get_time_id(TIME_ID_SHORT2))
	prnt_out("hr", get_time_id(TIME_HUM))
	prnt_out("hrr", get_time_id(TIME_HUM_RU))
	prnt_out("hrs", get_time_id(TIME_HUM_SAFE))
	prnt_out("hrs2", get_time_id(TIME_HUM_SAFE2))
	prnt_out("v", get_ver_id())
	prnt_out("va", get_ver_id3())
	prnt_out("vs", get_ver_id2())
	prnt_out("vsa", get_ver_id4())
	fmt.Println("")
}

func main() {
	if len(os.Args) > 1 {
		switch os.Args[1] {
		case "uuid":
			fmt.Println(get_uuid())
		case "uuid7":
			fmt.Println(get_uuid7())
		case "ts":
			fmt.Println(get_time_id(TIME_ID))
		case "hr":
			fmt.Println(get_time_id(TIME_HUM))
		case "hrr":
			fmt.Println(get_time_id(TIME_HUM_RU))
		case "hrs":
			fmt.Println(get_time_id(TIME_HUM_SAFE))
		case "hrs2":
			fmt.Println(get_time_id(TIME_HUM_SAFE2))
		case "tss":
			fmt.Println(get_time_id(TIME_ID_SHORT))
		case "tss2":
			fmt.Println(get_time_id(TIME_ID_SHORT2))
		case "v":
			fmt.Println(get_ver_id())
		case "va":
			fmt.Println(get_ver_id3())
		case "vs":
			fmt.Println(get_ver_id2())
		case "vsa":
			fmt.Println(get_ver_id4())
		default:
			fmt.Println("Need one of: ")
			fmt.Println("  uuid, uuid7, ts, tss, tss2, hr, hrr, hrs, hrs2,")
			fmt.Println("  v, va, vs, vsa")
		}
		fmt.Println("")
	} else {
		make_all_ids()
	}
}
