// devel.a0fs.ru -- aw_id -- v1.r202402.1 //
/*
  Утилиты генерирования полезных в работе ID
*/
package main

import (
	"fmt"
	"os"
	"time"

	"github.com/google/uuid"
)

const (
	TIME_ID = iota
	TIME_HUM
	TIME_HUM_SAFE
	TIME_HUM_SAFE2
	TIME_ID_SHORT
	TIME_ID_SHORT2
)

func get_time_id(id_type int) string {
	cur_time := time.Now()
	var time_format string = time.RFC3339

	switch id_type {
	case TIME_ID:
		time_format = "20060102-150405"
	case TIME_HUM:
		time_format = "2006-01-02 15:04:05"
	case TIME_HUM_SAFE:
		time_format = "2006-01-02 15-04-05"
	case TIME_HUM_SAFE2:
		time_format = "2006-01-02_15-04-05"
	case TIME_ID_SHORT:
		time_format = "20060102"
	case TIME_ID_SHORT2:
		time_format = "200601"
	}

	return cur_time.Format(time_format)
}

func get_uuid() string {
	res := uuid.New()
	return res.String()
}

func get_ver_id() string {
	return fmt.Sprintf("v0.r%s.1", get_time_id(TIME_ID_SHORT2))
}

func get_ver_id2() string {
	return fmt.Sprintf("0.%s.1", get_time_id(TIME_ID_SHORT2))
}

func prnt_out(k, v string) {
	fmt.Printf("%10s : %s\n", k, v)
}

func make_all_ids() {
	prnt_out("uuid", get_uuid())
	prnt_out("ts", get_time_id(TIME_ID))
	prnt_out("tss", get_time_id(TIME_ID_SHORT))
	prnt_out("tss2", get_time_id(TIME_ID_SHORT2))
	prnt_out("hr", get_time_id(TIME_HUM))
	prnt_out("hrs", get_time_id(TIME_HUM_SAFE))
	prnt_out("hrs2", get_time_id(TIME_HUM_SAFE2))
	prnt_out("v", get_ver_id())
	prnt_out("vs", get_ver_id2())
	fmt.Println("")
}

func main() {
	if len(os.Args) > 1 {
		switch os.Args[1] {
		case "uuid":
			fmt.Println(get_uuid())
		case "ts":
			fmt.Println(get_time_id(TIME_ID))
		case "hr":
			fmt.Println(get_time_id(TIME_HUM))
		case "hrs":
			fmt.Println(get_time_id(TIME_HUM_SAFE))
		case "hrs2":
			fmt.Println(get_time_id(TIME_HUM_SAFE2))
		case "tss":
			fmt.Println(get_time_id(TIME_ID_SHORT))
		case "tss2":
			fmt.Println(get_time_id(TIME_ID_SHORT2))
		case "v":
			fmt.Println(get_ver_id())
		case "vs":
			fmt.Println(get_ver_id2())
		default:
			fmt.Println("Need one of: uuid, ts, tss, tss2, hr, hrs, hrs2, v")
		}
		fmt.Println("")
	} else {
		make_all_ids()
	}
}
