#!/bin/sh
#
# $devel.a0fs.net: appdaemon - 0.5 awgur$
# $FreeBSD: head/www/uwsgi/files/uwsgi.in 340872 2014-01-24 00:14:07Z mat $
#
# PROVIDE: appdaemon
# REQUIRE: DAEMON
# KEYWORD: shutdown
#
# Add the following lines to /etc/rc.conf to enable appdaemon:
#
# appdaemon_enable (bool):       Set it to "YES" to enable appdaemon
#                                Default is "NO".
# appdaemon_piddir (path):       Directory with pid files of apps
#                                Default "/var/run/appdaemon"
# appdaemon_pidfile (path):      Set the path to the supervisor pid file
#                                Default is /var/run/appdaemon/${appName}.pid.
# appdaemon_app_pidfile (path):  Set the path to the app pid file
#                                Default is /var/run/appdaemon/${appName}.app.pid.
# appdaemon_user (str):          Set the UID of the process to run with
#                                Default is nobody.
# appdaemon_app (path):          Application binnary.
#                                Default is ""
# appdaemon_chdir (path):        Work directory of application
#                                Default is "/tmp"
# appdaemon_app_flags (str):     Flags needed by binary
#                                Default is ""
# appdaemon_self (str):          Binary of daemon program
#                                Default is "/usr/sbin/daemon"
# appdaemon_syslog_ident (srt):  Log all output to syslog with this identity.
#                                Default is ""
# appdaemon_flags (str):         Flags of daemon(8) command
#                                Default is "-fr"
#
# If you would like to have multiple instances running, you can
# define multiple profiles:
#
# appdaemon_profiles (str):      Set the list of profiles
#                                Default is "".
#
# For each profile you can then define different options (except for
# appdaemon_enable) using the syntax appdaemon_<profile>_<option>

. /etc/rc.subr

name="appdaemon"
fsname="appdaemon"
rcvar=`set_rcvar`
extra_commands="list"
list_cmd="my_list"

load_rc_config $name

: ${appdaemon_enable:="NO"}
: ${appdaemon_profiles:=""}
: ${appdaemon_piddir:="/var/run/${fsname}"}
: ${appdaemon_pidfile:="${appdaemon_piddir}/master.pid"}
: ${appdaemon_app_pidfile:="${appdaemon_piddir}/app.pid"}
: ${appdaemon_app_flags:=""}
: ${appdaemon_user:="nobody"}
: ${appdaemon_app:=""}
: ${appdaemon_chdir:="/tmp"}
: ${appdaemon_flags:="-f"}
: ${appdaemon_self:="/usr/sbin/daemon"}
: ${appdaemon_syslog_ident:=""}
: ${_appdaemon_prefix:="/usr/local"}
: ${_appdaemon_instance:="appdaemon"}


is_my_profile() {
    local profile
    for profile in ${appdaemon_profiles} ; do
        if [ "$profile" = "$1" ]; then
            return 0
        fi
    done

    return 1
}

my_err () {
    err $1 "${_appdaemon_instance}: $2"
}

my_list () {
    if [ -z "${appdaemon_profiles}" ] ; then
        echo "No profiles defineded"
    else
        echo "Profiles:"
        for p in ${appdaemon_profiles} ; do
            echo " - $p"
        done
    fi
    echo ""
    exit 
}

if ! checkyesno ${rcvar} ; then
    exit 0
fi

if [ -n "${appdaemon_profiles}" ]; then
    _process_profiles_flag="1"
    for c in ${extra_commands} ; do
        if [ "$1" = "$c" ] ; then
            _process_profiles_flag=""
	    break
        fi
    done
    if [ -n "$_process_profiles_flag" ] ; then
       if [ -n "$2" ]; then
            _profile="$2"
            if ! is_my_profile $_profile; then
                my_err 1 "$0: $_profile - no such profile defined in appdaemon_profiles."
            fi
            eval appdaemon_pidfile=\${appdaemon_${_profile}_pidfile:-"${appdaemon_piddir}/${_profile}.pid"}
            eval appdaemon_app_pidfile=\${appdaemon_${_profile}_app_pidfile:-"${appdaemon_piddir}/${_profile}.app.pid"}
            eval appdaemon_user=\${appdaemon_${_profile}_user:-"${appdaemon_user}"}
            eval appdaemon_app_flags=\${appdaemon_${_profile}_app_flags:-"${appdaemon_app_flags}"}
            eval appdaemon_self=\${appdaemon_${_profile}_self:-"${appdaemon_self}"}
            eval appdaemon_app=\"\${appdaemon_${_profile}_app:-"${appdaemon_app}"}\"
            eval appdaemon_chdir=\"\${appdaemon_${_profile}_chdir:-"${appdaemon_chdir}"}\"
            eval appdaemon_flags=\"\${appdaemon_${_profile}_flags:-"${appdaemon_flags}"}\"
            eval appdaemon_syslog_ident=\"\${appdaemon_${_profile}_syslog_ident:-"${appdaemon_syslog_ident}"}\"
            _appdaemon_instance="${_profile}"
        elif [ -n "$1" ]; then
            for _profile in ${appdaemon_profiles}; do
                echo "Processing ${name} profile: ${_profile}"
                ${_appdaemon_prefix}/etc/rc.d/${fsname} $1 ${_profile}
            done
            exit 0
        fi
   fi
fi

my_start_precmd () {
    # Checks
    if [ -z "${appdaemon_app}" ] ; then
        my_err 2 "command not set"
    elif ! [ -x "${appdaemon_app}" ] ; then
        my_err 3 "Command not found or not executable: ${appdaemon_app}"
    fi

    if ! [ -e "${appdaemon_piddir}" ] ; then
        mkdir -p "${appdaemon_piddir}"
    fi
}

my_start_postcmd () {
    sleep 0.4
    local _app_pid=`cat "${appdaemon_app_pidfile}"`
    local _d_pid=`cat "${appdaemon_pidfile}"`
    sleep 1
    if ! [ "${_app_pid}" = "`cat "${appdaemon_app_pidfile}"`" ] ; then
        if [ "${_d_pid}" ] ; then
            kill -9 "${_d_pid}"
        fi
        my_err 10 "app not lounch. Check it"
    fi
}

my_status_postcmd () {
    local _pids=""
    if [ -f "${appdaemon_pidfile}" ] ; then
        _pids="${_pids} -p `cat "${appdaemon_pidfile}"`"
    fi

    if [ -f "${appdaemon_app_pidfile}" ] ; then
        _pids="${_pids} -p `cat "${appdaemon_app_pidfile}"`"
    fi

    if [ -n "${_pids}" ] ; then
        echo ""
        ps ux ${_pids}
        echo ""
    fi
}

command="${appdaemon_self}"
command_args="-r ${appdaemon_flags} -P ${appdaemon_pidfile} -p ${appdaemon_app_pidfile} -u ${appdaemon_user} ${appdaemon_app} ${appdaemon_app_flags}"

if [ "x${appdaemon_syslog_ident}" != "x" ] ; then
    command_args="-ST ${appdaemon_syslog_ident} ${command_args}"
fi

appdaemon_user=""
pidfile="${appdaemon_pidfile}"
start_precmd=my_start_precmd
start_postcmd=my_start_postcmd
status_postcmd=my_status_postcmd
run_rc_command "$1"