package main

import (
	"fmt"
	"net"
	"os"

	idna "golang.org/x/net/idna"
)

func say_err(msg interface{}) {
	_, err := fmt.Fprintf(os.Stderr, "ERROR: %s\n", msg)
	if err != nil {
		panic(err)
	}

	os.Exit(1)
}

func main() {
	if len(os.Args) < 2 {
		say_err("Need hostname or IP as argument")
	}

	arg := os.Args[1]

	ip := net.ParseIP(arg)

	if ip != nil {
		res, err := net.LookupAddr(ip.String())
		if err != nil {
			say_err(err)
		}

		for _, i := range res {
			fmt.Println(i)
		}

	} else {
		hostname, err := idna.ToASCII(arg)
		if err != nil {
			say_err(err)
		}

		res, err := net.LookupHost(hostname)
		if err != nil {
			say_err(err)
		}

		for _, i := range res {
			fmt.Println(i)
		}

	}

}
