#!/bin/sh
# devel.a0fs.ru -- backup.ncc.vhost:/root/libexec/proxmox-s3-push.sh -- v0.r202312.2

export PATH=/usr/local/sbin:/usr/local/bin:/usr/sbin:/usr/bin:/sbin:/bin

BACKET="Change-me-please"     # Имя бакета на S3
STORE_CLASS="COLD"            # Тип хранения (см документацию по сервису)

operation="$1"
# backup-end - Завершение РК, можно отправить файл в s3
# log-end    - Завершение записи лога, можно отпарвить лог в S3

vmid="$3"

# Переменные окружения, принимаемые от СРК
# TARGET - Имя файла с РК
# LOGFILE - Имя файла журнала


log () {
    logger -t proxmox-s3-pusher "$@"

}


push_s3 () {
    local fd="$1"
    local fd_bn="$(basename "$fd")"

    log "Sending to s3: ${fd_bn} at '$fd'"

    s3cmd put --storage-class "$STORE_CLASS" "$fd" "s3://${BACKET}/${vmid}/${fd_bn}" 2>&1 | tr -d "\r" | log

}


# DO
log "Got ${operation} on ${vmid}, with arguments: $*"
case "$operation" in
    backup-end )
        push_s3 "$TARGET"
        ;;
    
    log-end)
        push_s3 "$LOGFILE"
        ;;

    manual-push)
        vmid="$2"
        log "Got manual push, vmid is $vmid"
        push_s3 "$3"
        ;;

    * )
        log "Ignoring it..."
        ;;

esac
