Мотивация
=========

Есть прекрасная платформа `windows`. И есть в ней сервисы разные, но нет консоли нормальной. Либо `cmd`,
либо `powershell` и крутись как хочешь...

Для того чтобы не крутиться хотя бы в вопросах резервных копий `PostgreSQL` создан этот модуль.

Почему не другие решения? Поскольку хорошее решение требует нормальной инфраструктуры, а не `PostgreSQL` на `Windows`.
В нормальной инфраструктуре это всё делается проще и скрипты уже есть. Но здесь `windows`

Кроме того, имея эту основу можно попытаться сделать нечто более сложное.


Как пользоваться?
=================

Запуск модуля через `c:\python38\python.exe -m win_pg_dump_controller c:\etc\pg_backup.config`.
`c:\etc\pg_backup.config` файл в формате `INI`. Пример файла в `examples`


Описание Конфигурационного файла
--------------------------------

### Секции

* `main` - основная конфигурация скрипта
* `common` - общие параметры заданий
* `smtp` - настройка оповещения через почту
* `${Имя задания}` - параметры задания. `${Имя задания}` задаётся пользователем, чтобы ему было понятно. 
  Оно фигурирует в журналах, используется в файлах резерных копий. Поэтому есть смысл избегать в нём русских букв
  и специальных символов


### Параметры в `main`

* `pg_bin_path` - расположение директории `bin` нужной инстраляции `PostgreSQL`. 
   Можно поискать файл `pg_dump.exe` и внести сюда ту директорию, в которой он лежит
* `pg_dump_flags` - если не хватает флагов `pg_dump`, недостающие можно перечислить здесь.
* `log_dir` - каталог, куда будут писаться логи всего что происходит. Если не задан, логи писаться не будут.
* `teir1_days` - период самых последних резервных копий. Количество дней, за которые они вообще чиститься не будут.
   По умолчанию 7 дней.
* `teir2_copies_interval` - архивный период резервных копий, количество дней между сохранёнными копиями. То есть 
  за этот период будет храниться только одна, самая старая копия. По умолчанию 7 дней
* `tier2_store_days` - за этим количеством дней копии чистятся. По умолчанию 30 дней
* `keep_logs_days` - количество дней за который хранить журналы.


### Параметры в `smtp`

* `smtp server` - IP или имя узла SMTP сервера
* `smtp port` - Порт SMTP сервера
* `mail from` - E-Mail источника почты
* `mail to` - Имя ПЯ куда отправлять письма


### Параметры `common` и раздела задач

* `host_name` - имя или IP узла баз данных. По умолчанию `127.0.0.1`
* `db_name` - имя базы данных
* `user_name` - имя пользователя для подключения к серверу
* `passwd` - пароль пользователя
* `port` - порт сервера баз данных
* `dst_dir` - каталог, к котором будут хранится резервные копии задания.
