# coding: utf-8

from .log_controller import LogController
from .config import Config
from .executor import backup
from .error import Error

config = Config()
log_controller = LogController(config)

log = log_controller.get_logger('main')
try:
    log_t = log.get_timing()

    log(log_t(f'Начало процесса'))

    for task in config.tasks:
        log(log_t(f'Обработка: {task.name}'))
        backup(task, config, log_controller)

        log(log_t(f'Завершение обработки: {task.name}'))

    log(log_t('Очистка старых журналов...'))
    log_controller.clean()
    log(log_t('Завершено'))

except Error as e:
    log.err(str(e))
    print('FAIL')
    exit(1)

except:
    log.excpt('Неизвестная ошибка')
    print('FAIL')
    exit(2)

else:
    print('ok')